/**********************************************************
 *(c) by Knobloch GmbH
 *       Weedgasse 14 
 *       D-55234 Erbes-Bdesheim                                    
 *
 *  Headerdatei:    TAF_00D.h   Headerfile for Robo-Interface C-Compiler
 *                              Section: TransferArea and Firmware 
 *                              Typ:     Structures and Constants
 *
 *  Version:        0.65
 *
 *  Revisionen:
 *          0.01:   16.11.2005
 *                  Start
 *          0.62:   11.03.2006
 *                  Base+0x1B6..0x1B7: MsgNumInBuffer;
 *          0.65:   12.05.2006
 *                  New Version of SendFtMessage()
 **********************************************************/


/**** Header Dateien ***************************************/


#ifndef TAF_00_D
    #define TAF_00_D


    #ifndef KE_C_DEFINITIONEN
        #include    "..\TA_Firmware\ke_c.h"
    #endif

    #ifndef TAF_00_P
        #include    "..\TA_Firmware\TAF_00P.h"
    #endif


    #define     ERROR_SUCCESS               0       // no Error



    // This structure is updated every 10ms from the Interface Firmware
    // It starts at address 0x00400 
    struct sFtTransferArea 
    {
        // Digital Inputs Main Module
        // Base+0x00: | E8 | E7 | E6 | E5 | E4 | E3 | E2 | E1 |
        unsigned char E_Main;
    
        // Digital Inputs Extension Modules 1..3
        // Base+0x01: | E16| E15| E14| E13| E12| E11| E10| E9 |
        unsigned char E_Sub1;
        // Base+0x02: | E24| E23| E22| E21| E20| E19| E18| E17|
        unsigned char E_Sub2;
        // Base+0x03: | E32| E31| E30| E29| E28| E27| E26| E25|
        unsigned char E_Sub3;
    
        // Reserved
        // Base+0x04..0x0B
        unsigned char rsvd1[8];
    
        // Abstandsensoren (1=detektiert)
        // Base+0x0C: |  0 |  0 |  0 |  0 |  0 |  0 | D2 | D1 |
        unsigned char Distance;
    
        // Base+0x0D: reserved
        unsigned char rsvd2;
    
        // IR-Receiver input code 
        // Base+0x0E: | 0 | 0 | 0 | C | T | T | T | T
        // C = Code: 0 = Code 1 active, 1 = Code 2 active
        // TTTT = Keycode 0..11
        // Arangement of keys on Transmitter
        //   1        8
        //   2     7
        //   3          10
        //   4      9
        //   5        11
        //   6
        // Taste 1 = M3 right
        // Taste 2 = M3 left
        // Taste 3 = Speed. M1
        // Taste 4 = Speed. M2
        // Taste 5 = Speed. M3
        // Taste 6 = Code 2
        // Taste 7 = M1 backward
        // Taste 8 = M1 forward
        // Taste 9 = M2 left
        // Taste 10 = M2 right
        // Taste 11 = Code 1
        unsigned char IRKeys;
    
        // Base+0x0F: | 0 | 0 | 0 | 0 | 0 | 0 | 0 | 0 |
        unsigned char res_1;
    
        // Analoginputs of main module
        // 8x 16 Bit, Range 0..1023, L:H Format (intel) )
        // Base+0x10..0x11: AX (Master Modul)
        unsigned short AX;
        // Base+0x12..0x13: AY (Master Modul)
        unsigned short AY;
        // Base+0x14..0x15: A1 (Master Modul)
        unsigned short A1;
        // Base+0x16..0x17: A2 (Master Modul)
        unsigned short A2;
        // Base+0x18..0x19: AZ (Master Modul, vom SLAVE-Modul-BUS)
        unsigned short AZ;
        // Base+0x1A..0x1B: AV (Versorgungsspannung Master Modul)
        unsigned short AV;
        // Base+0x1C..0x1D: D1 (Abstandssensor 1)
        unsigned short D1;
        // Base+0x1E..0x1F: D2 (Abstandssensor 2)
        unsigned short D2;
    
        // Analoginputs of slave modules 1..3 
        // Base+0x20..0x21: AX (Slave 1 Modul)
        unsigned short AXS1;
        // Base+0x22..0x23: AX (Slave 2 Modul)
        unsigned short AXS2;
        // Base+0x24..0x25: AX (Slave 3 Modul)
        unsigned short AXS3;
    
        // Detection limit for distance sensors (Base+0x0C) ( to generate digital from analog input )
        // Base+0x26..0x27: DS1
        unsigned short DS1;
        // Base+0x28..0x29: DS2
        unsigned short DS2;
    
        // Fast counter input (16-Bit, 26pin. Extensionconnector) 
        // Base+0x2A..0x2B: ZE (Master Modul)
        unsigned short ZE;
    
        // Reserved
        // Base+0x2C..0x2F
        unsigned char rsvd3[4];
    
        // 16-Bit Timers
        // Base+0x30..0x31: Timer 1ms Inkrement
        // Note: Timer1ms is Interface Time!
        //       It is not Inkrement linear because we 
        //       have not every 1ms a DataPaket from the Interface!
        unsigned short Timer1ms;
        // Base+0x32..0x33: Timer 10ms Inkrement
        unsigned short Timer10ms;
        // Base+0x34..0x35: Timer 100ms Inkrement
        unsigned short Timer100ms;
        // Base+0x36..0x37: Timer 1s Inkrement
        unsigned short Timer1s;
        // Base+0x38..0x39: Timer 10s Inkrement
        unsigned short Timer10s;
        // Base+0x3A..0x3B: Timer 1min Inkrement
        unsigned short Timer1min;
    
        // Reserved
        // Base+0x3C..0x3D
        unsigned short res_bF;
        // Base+0x3E
        unsigned char res_bT;
    
        // Reserved
        // Base+0x3F
        unsigned char rsvd4[1];
    
        // Outputs of the main module ( polarity )
        // Base+0x40: |M4B |M4A |M3B |M3A |M2B |M2A |M1B |M1A |
        unsigned char M_Main;
        // Outputs of extension modules 1..3
        // Base+0x41: |M8B |M8A |M7B |M7A |M6B |M6A |M5B |M5A |
        unsigned char M_Sub1;
        // Base+0x42: |M12B|M12A|M11B|M11A|M10B|M10A|M9B |M9A |
        unsigned char M_Sub2;
        // Base+0x43: |M16B|M16A|M15B|M15A|M14B|M14A|M13B|M13A|
        unsigned char M_Sub3;
    
        // Reserved
        // Base+0x44..0x47
        unsigned char rsvd5[4];
    
        // Outputs of the main module ( energy saver mode )
        // 1 = energy saver mode, 0 = operational, PowerUp = 1
        // Base+0x48: | 0  | 0  | 0  | 0  | M4 | M3 | M2 | M1 |
        unsigned char MES_Main;
        // Outputs of extension modules 1..3
        // Base+0x49: | 0  | 0  | 0  | 0  | M8 | M7 | M6 | M5 |
        unsigned char MES_Sub1;
        // Base+0x4A: | 0  | 0  | 0  | 0  | M12| M11| M10| M9 |
        unsigned char MES_Sub2;
        // Base+0x4B: | 0  | 0  | 0  | 0  | M16| M15| M14| M13|
        unsigned char MES_Sub3;
    
        // Reserved
        // Base+0x4C
        unsigned char rsvd6[1];
    
        // Reserved
        // Base+0x4D:
        unsigned char reserved_l1;
        // Reserved
        // Base+0x4E: 
        unsigned char reserved_l2;
        // Reserved
        // Base+0x4F: 
        unsigned char reserved_l3;
    
        // Outputs of the main module (PWM values, range =0..7)
        // Base+0x50: M1A
        // Base+0x51: M1B
        // Base+0x52: M2A
        // Base+0x53: M2B
        // Base+0x54: M3A
        // Base+0x55: M3B
        // Base+0x56: M4A
        // Base+0x57: M4B
        unsigned char MPWM_Main[8];
    
        // Outputs of slave module 1 (PWM values, range =0..7)
        // Base+0x58: M5A
        // Base+0x59: M5B
        // Base+0x5A: M6A
        // Base+0x5B: M6B
        // Base+0x5C: M7A
        // Base+0x5D: M7B
        // Base+0x5E: M8A
        // Base+0x5F: M8B
        unsigned char MPWM_Sub1[8];
    
        // Outputs of slave module 2 (PWM values, range =0..7)
        // Base+0x60: M9A
        // Base+0x61: M9B
        // Base+0x62: M10A
        // Base+0x63: M10B
        // Base+0x64: M11A
        // Base+0x65: M11B
        // Base+0x66: M12A
        // Base+0x67: M12B
        unsigned char MPWM_Sub2[8];
    
        // Outputs of slave module 3 (PWM values, range =0..7)
        // Base+0x68: M13A
        // Base+0x69: M13B
        // Base+0x6A: M14A
        // Base+0x6B: M14B
        // Base+0x6C: M15A
        // Base+0x6D: M15B
        // Base+0x6E: M16A
        // Base+0x6F: M16B
        unsigned char MPWM_Sub3[8];
    
        // Reserved
        // Base+0x70..0x8F
        unsigned char rsvd7[32];
    
    
        // Analoginputs of slave modules 1..3 (Update-Time: 20ms)
        // Base+0x90..0x91: A1 (Slave 1 Modul)
        unsigned short A1S1;
        // Base+0x92..0x93: A1 (Slave 2 Modul)
        unsigned short A1S2;
        // Base+0x94..0x95: A1 (Slave 3 Modul)
        unsigned short A1S3;
    
        // Analoginputs of slave modules 1..3 (Update-Time: 20ms) 
        // Base+0x96..0x97: AV (Slave 1 Modul)
        unsigned short AVS1;
        // Base+0x98..0x99: AV (Slave 2 Modul)
        unsigned short AVS2;
        // Base+0x9A..0x9B: AV (Slave 3 Modul)
        unsigned short AVS3;
    
        // Reserved
        // Base+0x9C..0x9F
        unsigned char rsvd8[4];
    
        // Reserved
        // Base+0xA0..0xA1: AX (Interface) Resistor-Value (0..5662 Ohm)
        unsigned short AX_R;
    
        // Base+0xA2..0xA3: AY (Interface) Resistor-Value (0..5662 Ohm)
        unsigned short AY_R;
    
        // Base+0xA4..0xA5: AX (Slave 1 Modul) Resistor-Value (0..5662 Ohm)
        unsigned short AXS1_R;
    
        // Base+0xA6..0xA7: AX (Slave 2 Modul) Resistor-Value (0..5662 Ohm)
        unsigned short AXS2_R;
    
        // Base+0xA8..0xA9: AX (Slave 3 Modul) Resistor-Value (0..5662 Ohm)
        unsigned short AXS3_R;
    
        // Reserved
        // Base+0xAA..0xDF
        unsigned char rsvd10[54];
 

        // Reserved for later use
        // Base+0xE0: for later use
        unsigned char Mode;
    
        // Output PWM update (0x01=always, 0x02=once)
        // Base+0xE1: | 0  | 0  | 0  | 0  | 0  | 0  |ONCE|ALWA|
        unsigned char MPWM_Update;
    

        // Reserved for later use
        // Base+0xE2
        unsigned char TransferAktiv;
    
        // Reserved
        // Base+0xE3..0xE5
    
        unsigned char rsvd11[3];
    
        // Bus connected extension modules (number of I/O Extensions)
        // Base+0xE6: | 0  | 0  | 0  | 0  | 0  | S3 | S2 | S1 |
        unsigned char BusModules;
    
        // Reserved for later use
        // Base+0xE7: ?
        unsigned char SlotModule1;
    
        // Reserved for later use
        // Base+0xE8: ?
        unsigned char SlotModule2;
    
        // Reserved
        // Base+0xE9..0xEF
        unsigned char rsvd12[7];
    
    
        // Change Bytes
        // 1 = EG (Master or Slave 1..3) have changed
        // The Application must read and change this byte to "0"
        // Use the Windows InterlockedExchange() Function for reading and writing at the same time!
        // Base+0xF0: 
        unsigned char ChangeEg;
    
        // 1 = Analog Inputs (Master EX, EY, A1, A2 or Slave 1..3 EX,EY)
        // or RfPower, RfError have changed
        // The Application must read and change this byte to "0"
        // Use the Windows InterlockedExchange() Function for reading and writing at the same time!
        // Base+0xF1: 
        unsigned char ChangeAn;
    
        // 1 = Infrared Input (Robo-IF) or RfStatus have changed
        // The Application must read and change this byte to "0"
        // Use the Windows InterlockedExchange() Function for reading and writing at the same time!
        // Base+0xF1: 
        unsigned char ChangeIr;
    
        // Reserved
        // Base+0xF3..0xFF
        unsigned char rsvd13[13];
    
        // Digital inputs as 16 bit values
        // Base+0x100..0x101  Input 1 (Master-Modul)
        // Base+0x102..0x103  Input 2 (Master-Modul)
        // Base+0x104..0x105  Input 3 (Master-Modul)
        // Base+0x106..0x107  Input 4 (Master-Modul)
        // Base+0x108..0x109  Input 5 (Master-Modul)
        // Base+0x10A..0x10B  Input 6 (Master-Modul)
        // Base+0x10C..0x10D  Input 7 (Master-Modul)
        // Base+0x10E..0x10F  Input 8 (Master-Modul)
        unsigned short E16_Main[8];
        // Base+0x110..0x111  Input 9 (Slave1-Modul)
        // Base+0x112..0x113  Input 10 (Slave1-Modul)
        // Base+0x114..0x115  Input 11 (Slave1-Modul)
        // Base+0x116..0x117  Input 12 (Slave1-Modul)
        // Base+0x118..0x119  Input 13 (Slave1-Modul)
        // Base+0x11A..0x11B  Input 14 (Slave1-Modul)
        // Base+0x11C..0x11D  Input 15 (Slave1-Modul)
        // Base+0x11E..0x11F  Input 16 (Slave1-Modul)
        unsigned short E16_Sub1[8];
        // Base+0x120..0x121  Input 17 (Slave2-Modul)
        // Base+0x122..0x123  Input 18 (Slave2-Modul)
        // Base+0x124..0x125  Input 19 (Slave2-Modul)
        // Base+0x126..0x127  Input 20 (Slave2-Modul)
        // Base+0x128..0x129  Input 21 (Slave2-Modul)
        // Base+0x12A..0x12B  Input 22 (Slave2-Modul)
        // Base+0x12C..0x12D  Input 23 (Slave2-Modul)
        // Base+0x12E..0x12F  Input 24 (Slave2-Modul)
        unsigned short E16_Sub2[8];
        // Base+0x130..0x131  Input 25 (Slave3-Modul)
        // Base+0x132..0x133  Input 26 (Slave3-Modul)
        // Base+0x134..0x135  Input 27 (Slave3-Modul)
        // Base+0x136..0x137  Input 28 (Slave3-Modul)
        // Base+0x138..0x139  Input 29 (Slave3-Modul)
        // Base+0x13A..0x13B  Input 30 (Slave3-Modul)
        // Base+0x13C..0x13D  Input 31 (Slave3-Modul)
        // Base+0x13E..0x13F  Input 32 (Slave3-Modul)
        unsigned short E16_Sub3[8];
        // Base+0x140..0x141  Distance sensor D1 (Master-Modul)
        // Base+0x142..0x143  Distance sensor D2 (Master-Modul)
        unsigned short Distance16[2];
    
        // Reserved
        // Base+0x140..0x14F
        unsigned char rsvd14[12];
     
        // IR-Keys as 16 bit values (independent of code)
        // Base+0x150..0x151  IR Taste  1 (M3R)
        // Base+0x152..0x153  IR Taste  2 (M3L)
        // Base+0x154..0x155  IR Taste  3 (M1)
        // Base+0x156..0x157  IR Taste  4 (M2)
        // Base+0x158..0x159  IR Taste  5 (M3)
        // Base+0x15A..0x15B  IR Taste  6 (Code2)
        // Base+0x15C..0x15D  IR Taste  7 (M1BW)
        // Base+0x15E..0x15F  IR Taste  8 (M1FW)
        // Base+0x160..0x161  IR Taste  9 (M2L)
        // Base+0x162..0x163  IR Taste 10 (M2R)
        // Base+0x164..0x165  IR Taste 11 (Code1)
        unsigned short IRKeys16[11];
        // Reserved
        // Base+0x166..0x16F
        unsigned char rsvd15[10];
    
        // IR-Keys as 16 bit values (code 1)
        // Base+0x170..0x171  IR Taste  1 (M3R)    Code1
        // Base+0x172..0x173  IR Taste  2 (M3L)    Code1
        // Base+0x174..0x175  IR Taste  3 (M1)     Code1
        // Base+0x176..0x177  IR Taste  4 (M2)     Code1
        // Base+0x178..0x179  IR Taste  5 (M3)     Code1
        // Base+0x17A..0x17B  always 0
        // Base+0x17C..0x17D  IR Taste  7 (M1BW)   Code1
        // Base+0x17E..0x17F  IR Taste  8 (M1FW)   Code1
        // Base+0x180..0x181  IR Taste  9 (M2L)    Code1
        // Base+0x182..0x183  IR Taste 10 (M2R)    Code1
        // Base+0x184..0x185  IR Taste 11 (Code1)  Code1 
        unsigned short IRKeys16Code1[11];
    
        // Reserved
        // Base+0x186..0x18F
        unsigned char rsvd16[10];
     
        // IR-Keys as 16 bit values (code 1)
        // Base+0x190..0x191  IR Taste  1 (M3R)    Code2
        // Base+0x192..0x193  IR Taste  2 (M3L)    Code2
        // Base+0x194..0x195  IR Taste  3 (M1)     Code2
        // Base+0x196..0x197  IR Taste  4 (M2)     Code2
        // Base+0x198..0x199  IR Taste  5 (M3)     Code2
        // Base+0x19A..0x19B  IR Taste  6 (Code2)  Code2 
        // Base+0x19C..0x19D  IR Taste  7 (M1BW)   Code2
        // Base+0x19E..0x19F  IR Taste  8 (M1FW)   Code2
        // Base+0x1A0..0x1A1  IR Taste  9 (M2LE)   Code2
        // Base+0x1A2..0x1A3  IR Taste 10 (M2RI)   Code2
        // Base+0x1A4..0x1A5  always 0
        unsigned short IRKeys16Code2[11];
    
        // Reserved
        // Base+0x1A6..0x1AF
        unsigned char rsvd17[10];
    
        // Base+0x1B0..0x1B1
        unsigned short rsvd18;
    
        // Base+0x1B2..0x1B3
        unsigned short rsvd19;
    
        // Base+0x1B4..0x1B5
        unsigned short rsvd20;

        // Base+0x1B6..0x1B7            // Number of Messages inside the buffer
        unsigned short MsgNumInBuffer;

        // Base+0x1B8
        unsigned char RfModulNr;

        // Reserved
        // Base+0x1B9
        unsigned char rsvd21;


        // Reserved for Internal Use
        // Base+0x1BA..0x1BF
        UINT uiTC;                      // nur 16Bit Zhler verwendet
        UINT uiTChigh;

        UINT uiX;                       // nur 16Bit Zhler verwendet

        // Reserved
        // Base+0x1C0..0x1EF
        unsigned char rsvd22[48];

        // for Debugging
        // Base+0x1F0..0x1FF
        unsigned char ucDbg1F0;
        unsigned char ucDbg1F1;
        unsigned char ucDbg1F2;
        unsigned char ucDbg1F3;
        unsigned char ucDbg1F4;
        unsigned char ucDbg1F5;
        unsigned char ucDbg1F6;
        unsigned char ucDbg1F7;
        unsigned char ucDbg1F8;
        unsigned char ucDbg1F9;
        unsigned char ucDbg1FA;
        unsigned char ucDbg1FB;
        unsigned char ucDbg1FC;
        unsigned char ucDbg1FD;
        unsigned char ucDbg1FE;
        unsigned char ucDbg1FF;
    };

    #define     TRANSFER_SIZE   sizeof(FT_TRANSFER_AREA)

    extern  near struct sFtTransferArea sTrans;



#endif

// End of File